<?php
 
/*
    The important thing to realize is that the config file should be included in every
    page of your project, or at least any page you want access to these settings.
    This allows you to confidently use these settings throughout a project because
    if something changes such as your database credentials, or a path to a specific resource,
    you'll only need to update it here.
*/
$config = array(
    "db" => array(
        "db1" => array(
            "dbname" => "star",
            "username" => "root",
            "password" => "",
            "host" => "localhost"
        ),
        
    "urls" => array(
        "baseUrl" => "/bills/"
    ),
    "paths" => array(
        "resources" => "/bills/resources",
        "images" => $_SERVER["DOCUMENT_ROOT"] . "/img",
        )
    )
);


/*
    I will usually place the following in a bootstrap file or some type of environment
    setup file (code that is run at the start of every page request), but they work 
    just as well in your config file if it's in php (some alternatives to php are xml or ini files).
*/
 
/*
    Creating constants for heavily used paths makes things a lot easier.
    ex. require_once(LIBRARY_PATH . "Paginator.php")
*/
ini_set("error_reporting", "true");
error_reporting(E_ALL|E_STRCT);
 
?>