<?php
 
/*
    The important thing to realize is that the config file should be included in every
    page of your project, or at least any page you want access to these settings.
    This allows you to confidently use these settings throughout a project because
    if something changes such as your database credentials, or a path to a specific resource,
    you'll only need to update it here.
*/
define('MAINDIR',dirname(__FILE__) . '/');
define('DL_DIR',MAINDIR . '/');
define('IMG_DIR','img/');
define('DB_DIR','resources/');
define('CON_DIR','resources/config/');
define("dbuser", "root");
define("dbpassword", "");
define("database", "star");
define("host", "localhost.");
define("hostip", "127.0.0.1");

define("custom_form",DB_DIR."add_new_customer_form.php");
define("connection",DB_DIR."conn.php");
define("search",DB_DIR."count.php");
define("footer",DB_DIR."footer.php");
define("payment_form",DB_DIR."form_payment.php");
define("header",DB_DIR."header.php");
define("header2",DB_DIR."java_header.php");
define("menu_penal",DB_DIR."menu.php");
define("search_pkg",DB_DIR."s_pkg.php");
define("config",DB_DIR."config/config.php");
define("search_name",DB_DIR."search_name.php");
define("package",DB_DIR."form_pkg.php");
define("header_r",DB_DIR."report_header.php");
define("header_e",DB_DIR."edit_head.php");
define("header_p",DB_DIR."edit_p.php");
define("logo",IMG_DIR."logo.png");
/*
    I will usually place the following in a bootstrap file or some type of environment
    setup file (code that is run at the start of every page request), but they work 
    just as well in your config file if it's in php (some alternatives to php are xml or ini files).
*/
 
/*
    Creating constants for heavily used paths makes things a lot easier.
    ex. require_once(LIBRARY_PATH . "Paginator.php")
*/


$filess1 =DB_DIR.'add_new_customer_form1.php';
$filess2 = DB_DIR.'conn.php';
$filess3 = DB_DIR.'count.php';
$filess4 = DB_DIR.'footer.php';
$filess5 = DB_DIR.'form_payment.php';
$filess6 = DB_DIR.'header.php';
$filess7 = DB_DIR.'java_header.php';
$filess8 = DB_DIR.'menu1.php';
$filess9 = DB_DIR.'s_pkg.php';
$filess10 = DB_DIR.'search_name.php';
$filess11 = IMG_DIR.'logo.png';
$files = array($filess1,$filess2,$filess3,$filess4,$filess5,$filess6,$filess7,$filess8,$filess9,$filess10,$filess11);
if (file_exists($filess1 or $filess2)) {
    //echo "The file $filess1 exists";
} else {
    //echo "The file $filess1 does not exist";
}
defined("LIBRARY_PATH")
    or define("LIBRARY_PATH", realpath(dirname(__FILE__) . '/library'));
     
defined("TEMPLATES_PATH")
    or define("TEMPLATES_PATH", realpath(dirname(__FILE__) . '/templates'));
 
/*
    Error reporting.
*/
ini_set("error_reporting", "true");
error_reporting(E_ALL|E_STRCT);
 
?>